<?php

namespace App\Modes\DoctorInsurances;

use Illuminate\Database\Eloquent\Model;

class DoctorInsurances extends Model 
{

    protected $table = 'doctor_insurances';
    public $timestamps = true;

    public function doctor()
    {
        return $this->belongsTo('Doctors', 'id');
    }

    public function influence()
    {
        return $this->belongsTo('Insurance', 'id');
    }

    public function logs()
    {
        return $this->hasMany('DoctorInsuranceLogs', 'insurance_id');
    }

}